implementation module windowupdate


//	Clean Object I/O library, version 1.1


import StdBool, StdFunc, StdList, StdMisc
import ospicture, oswindow
import commondef, devicefunctions, StdPicture, windowaccess, windowhandle


/*	updatewindow updates the window, using the UpdateInfo argument.
*/
updatewindow :: !UpdateInfo !(WindowHandle .ls .ps) !*OSToolbox -> (!WindowHandle .ls .ps,!*OSToolbox)
updatewindow info=:{updWIDS={wPtr},updGContext} wH tb
	# (osPict,tb)		= getUpdateContext wPtr updGContext tb
	# (wH,osPict,tb)	= updatebackground info wH osPict tb
	# (wH,osPict,tb)	= updatecontrols   info wH osPict tb
	# tb				= setUpdateContext wPtr updGContext osPict tb
	= (wH,tb)
where
	getUpdateContext :: OSWindowPtr !(Maybe OSPictContext) !*OSToolbox -> (!OSPictContext,!*OSToolbox)
	getUpdateContext _ (Just osPict) tb
		= (osPict,tb)
	getUpdateContext wPtr _ tb
		= OSgrabWindowPictContext wPtr tb
	
	setUpdateContext :: !OSWindowPtr !(Maybe OSPictContext) !OSPictContext !*OSToolbox -> *OSToolbox
	setUpdateContext wPtr updContext osPict tb
		|	isJust updContext
			=	tb
		|	otherwise
			=	OSreleaseWindowPictContext wPtr osPict tb

updatebackground :: !UpdateInfo !(WindowHandle .ls .ps) !OSPictContext !*OSToolbox
							 -> (!WindowHandle .ls .ps, !OSPictContext,!*OSToolbox)
updatebackground info wH=:{whWindowInfo,whSize} osPict tb
	| IsEmptyRect updRect || isNothing whWindowInfo
	= (wH,osPict,tb)
	# wFrame			= {corner1=origin,corner2={x=min (origin.x+w) domain.corner2.x,y=min (origin.y+h) domain.corner2.y}}
	  updArea			= RectToRectangle (IntersectRects (RectangleToRect wFrame) (RectangleToRect updArea))	// PA: note that updArea might be empty!!
	  updState			= {oldFrame=wFrame,newFrame=wFrame,updArea=[updArea]}
	# picture			= packPicture origin lookInfo.lookPen osPict tb
// MW: was	# picture	= clip updArea (lookInfo.lookFun selectState updState) picture
	# picture			= appClipPicture (toRegion updArea) (lookInfo.lookFun selectState updState) picture
	# (_,pen,osPict,tb)	= unpackPicture picture
	  wH				= {wH & whWindowInfo=Just {windowInfo & windowLook={lookInfo & lookPen=pen}}}
	  wFrameSize		= rectangleSize wFrame
	  overRects			= (if (wFrameSize.w<w) [{corner1={x=wFrameSize.w,y=0},corner2={x=w,y=wFrameSize.h}}] [])
	  					  ++
	  					  (if (wFrameSize.h<h) [{corner1={x=0,y=wFrameSize.h},corner2={x=w,y=h}}] [])
	| isEmpty overRects
	= (wH,osPict,tb)
	# picture			= packPicture zero defaultPen osPict tb
	# picture			= StrictSeq [setPenColour White:map fill overRects] picture
	# (_,_,osPict,tb)	= unpackPicture picture
	= (wH,osPict,tb)
where
	updRect				= info.updWindowArea
	(w,h)				= toTuple whSize
	(l,t, r,b)			= updRect
	updArea				= {corner1={x=origin.x+l,y=origin.y+t},corner2={x=origin.x+r,y=origin.y+b}}
	windowInfo			= fromJust whWindowInfo
	lookInfo			= windowInfo.windowLook
	origin				= windowInfo.windowOrigin
	domain				= windowInfo.windowDomain
	selectState			= if wH.whSelect Able Unable

updatecontrols :: !UpdateInfo !(WindowHandle .ls .ps) !OSPictContext !*OSToolbox
						  -> ( !WindowHandle .ls .ps, !OSPictContext,!*OSToolbox)
updatecontrols info=:{updWIDS,updControls} wH=:{whSelect,whItems} osPict tb
	# (_,itemHs,osPict,tb)	= updateControls updWIDS whSelect updControls whItems osPict tb
	= ({wH & whItems=itemHs},osPict,tb)
where
	updateControls :: !WIDS !Bool ![ControlUpdateInfo] ![WElementHandle .ls .ps] !OSPictContext !*OSToolbox
							  -> (![ControlUpdateInfo],![WElementHandle .ls .ps],!OSPictContext,!*OSToolbox)
	updateControls wids contextAble updControls itemHs osPict tb
		| isEmpty updControls || isEmpty itemHs
		= (updControls,itemHs,osPict,tb)
		# (itemH,itemHs)				= HdTl itemHs
		# (updControls,itemH, osPict,tb)= updateControl  wids contextAble updControls itemH  osPict tb
		# (updControls,itemHs,osPict,tb)= updateControls wids contextAble updControls itemHs osPict tb
		= (updControls,[itemH:itemHs],osPict,tb)
	where
		updateControl :: !WIDS !Bool ![ControlUpdateInfo] !(WElementHandle .ls .ps) !OSPictContext !*OSToolbox
								 -> (![ControlUpdateInfo], !WElementHandle .ls .ps, !OSPictContext,!*OSToolbox)
		updateControl wids contextAble updControls (WListLSHandle itemHs) osPict tb
			# (updControls,itemHs,osPict,tb)	= updateControls wids contextAble updControls itemHs osPict tb
			= (updControls,WListLSHandle itemHs,osPict,tb)
		updateControl wids contextAble updControls (WExtendLSHandle wExH=:{wExtendItems=itemHs}) osPict tb
			# (updControls,itemHs,osPict,tb)	= updateControls wids contextAble updControls itemHs osPict tb
			= (updControls,WExtendLSHandle {wExH & wExtendItems=itemHs},osPict,tb)
		updateControl wids contextAble updControls (WChangeLSHandle wChH=:{wChangeItems=itemHs}) osPict tb
			# (updControls,itemHs,osPict,tb)	= updateControls wids contextAble updControls itemHs osPict tb
			= (updControls,WChangeLSHandle {wChH & wChangeItems=itemHs},osPict,tb)
		updateControl wids contextAble updControls (WItemHandle itemH) osPict tb
			# (updControls,itemH,osPict,tb)		= updateControl` wids contextAble updControls itemH osPict tb
			= (updControls,WItemHandle itemH,osPict,tb)
		where
			updateControl` :: !WIDS !Bool ![ControlUpdateInfo] !(WItemHandle .ls .ps) !OSPictContext !*OSToolbox
									  -> (![ControlUpdateInfo], !WItemHandle .ls .ps, !OSPictContext,!*OSToolbox)
			updateControl` wids contextAble updControls itemH=:{wItemNr} osPict tb
				# (found,updInfo,updControls)	= Remove (\{cuItemNr}->cuItemNr==wItemNr) undef updControls
				# (updControls,itemHs,osPict,tb)= updateControls wids (contextAble && itemH.wItemSelect) updControls itemH.wItems osPict tb
				  itemH							= {itemH & wItems=itemHs}
				| not found
				= (updControls,itemH,osPict,tb)
				# (itemH,osPict,tb)				= updateControl`` wids contextAble updInfo.cuArea itemH osPict tb
				= (updControls,itemH,osPict,tb)
			where
				updateControl`` :: !WIDS !Bool !Rect !(WItemHandle .ls .ps) !OSPictContext !*OSToolbox
												  -> (!WItemHandle .ls .ps, !OSPictContext,!*OSToolbox)
				
				updateControl`` wids contextAble area itemH=:{wItemKind=IsRadioControl} osPict tb
					= (itemH,osPict,OSupdateRadioControl area wids.wPtr itemH.wItemPtr tb)
				
				updateControl`` wids contextAble area itemH=:{wItemKind=IsCheckControl} osPict tb
					= (itemH,osPict,OSupdateCheckControl area wids.wPtr itemH.wItemPtr tb)
				
				updateControl`` wids contextAble area itemH=:{wItemKind=IsPopUpControl} osPict tb
					= (itemH,osPict,OSupdatePopUpControl area wids.wPtr itemH.wItemPtr tb)
				
				updateControl`` wids contextAble area itemH=:{wItemKind=IsSliderControl} osPict tb
					= (itemH,osPict,OSupdateSliderControl area wids.wPtr itemH.wItemPtr tb)
				
				updateControl`` wids contextAble area itemH=:{wItemKind=IsTextControl} osPict tb
					= (itemH,osPict,OSupdateTextControl area wids.wPtr itemH.wItemPtr tb)
				
				updateControl`` wids contextAble area itemH=:{wItemKind=IsEditControl} osPict tb
					= (itemH,osPict,OSupdateEditControl area wids.wPtr itemH.wItemPtr tb)
				
				updateControl`` wids contextAble area itemH=:{wItemKind=IsButtonControl} osPict tb
					= (itemH,osPict,OSupdateButtonControl area wids.wPtr itemH.wItemPtr tb)
				
				updateControl`` wids contextAble area itemH=:{wItemKind=IsCustomButtonControl} osPict tb
					# picture				= packPicture zero lookInfo.lookPen osPict tb
//MW: was			# picture				= clip updArea (lookInfo.lookFun selectState updState) picture
					# picture				= appClipPicture (toRegion updArea) 
															 (lookInfo.lookFun selectState updState) picture
					# (_,pen,osPict,tb)		= unpackPicture picture
					  info					= {info & cButtonInfoLook={lookInfo & lookPen=pen}}
					= ({itemH & wItemInfo=CustomButtonInfo info},osPict,tb)
				where
					selectState				= if (contextAble && itemH.wItemSelect) Able Unable
					info					= getWItemCustomButtonInfo itemH.wItemInfo
					lookInfo				= info.cButtonInfoLook
					{x,y}					= itemH.wItemPos
					(left,top,right,bottom)	= area
					cFrame					= SizeToRectangle itemH.wItemSize
					updArea					= RectToRectangle (left-x,top-y, right-x,bottom-y)
					updState				= {oldFrame=cFrame,newFrame=cFrame,updArea=[updArea]}
				
				updateControl`` wids contextAble area itemH=:{wItemKind=IsCustomControl} osPict tb
					# picture				= packPicture zero lookInfo.lookPen osPict tb
//MW: was			# picture				= clip updArea (lookInfo.lookFun selectState updState) picture
					# picture				= appClipPicture (toRegion updArea) 
															 (lookInfo.lookFun selectState updState) picture
					# (_,pen,osPict,tb)		= unpackPicture picture
					  info					= {info & customInfoLook={lookInfo & lookPen=pen}}
					= ({itemH & wItemInfo=CustomInfo info},osPict,tb)
				where
					selectState				= if (contextAble && itemH.wItemSelect) Able Unable
					info					= getWItemCustomInfo itemH.wItemInfo
					lookInfo				= info.customInfoLook
					{x,y}					= itemH.wItemPos
					(left,top,right,bottom)	= area
					cFrame					= SizeToRectangle itemH.wItemSize
					updArea					= RectToRectangle (left-x,top-y, right-x,bottom-y)
					updState				= {oldFrame=cFrame,newFrame=cFrame,updArea=[updArea]}
				
				updateControl`` wids contextAble area itemH=:{wItemKind=IsCompoundControl} osPict tb
					| isNothing info.compoundLookInfo
					= (itemH,osPict,tb)
					# picture				= packPicture origin lookInfo.lookPen osPict tb
//MW: was					# picture				= clip updArea (lookInfo.lookFun selectState updState) picture
					# picture				= appClipPicture (toRegion updArea) 
															 (lookInfo.lookFun selectState updState) picture
					# (_,pen,osPict,tb)		= unpackPicture picture
					  info					= {info & compoundLookInfo=Just {compLookInfo & compoundLook={lookInfo & lookPen=pen}}}
					= ({itemH & wItemInfo=CompoundInfo info},osPict,tb)
				where
					selectState				= if (contextAble && itemH.wItemSelect) Able Unable
					info					= getWItemCompoundInfo itemH.wItemInfo
					compLookInfo			= fromJust info.compoundLookInfo
					lookInfo				= compLookInfo.compoundLook
					origin					= info.compoundOrigin
					{x,y}					= origin-itemH.wItemPos
					(left,top,right,bottom)	= area
					cFrame					= PosSizeToRectangle origin itemH.wItemSize
					updArea					= RectToRectangle (x+left,y+top, x+right,y+bottom)
					updState				= {oldFrame=cFrame,newFrame=cFrame,updArea=[updArea]}
				
				updateControl`` _ _ _ itemH=:{wItemKind=IsOtherControl _} osPict tb
					= (itemH,osPict,tb)
